import { StarXpandCommand } from "star-io10-web";

export class LabelSample14_For203dpiAnd300dpi_ExpirationLabelJP {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          // モデルにより対応する文字エンコーディング指定APIが異なります。
          // 下記ページのSupported Modelを参照し、ご利用のモデルが対応するAPIを使用してください。
          // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-cjk-character-priority.html
          .styleCjkCharacterPriority([
            StarXpandCommand.Printer.CjkCharacterType.Japanese,
          ])
          // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-second-priority-character-encoding.html
          //.styleSecondPriorityCharacterEncoding(CharacterEncodingType.Japanese)

          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(2, 2),
              )
              .actionPrintText("＜要冷蔵＞\n"),
          )
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
              .actionPrintText(
                "10℃以下で保存し、本日中にお召し上がり下さい。\n" +
                  "　　消費期限\n",
              ),
          )
          .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
          .styleMagnification(new StarXpandCommand.MagnificationParameter(2, 2))
          .actionPrintText("2010.1.25\n")
          .styleMagnification(new StarXpandCommand.MagnificationParameter(1, 1))
          .actionPrintText(
            "スターショップ\n" +
              "静岡　太郎\n" +
              "XXX県XXX市XXX町123-1\n" +
              "TEL 1234-567-890\n",
          )
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
